<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'maintenance' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['maintenance']);
	
	print_form_header('vbsecurity', 'maintenance');
	construct_hidden_code('action', 'doreset');
	print_table_header($vbphrase['dbtech_vbsecurity_passwordreset'], 2, 0);
	print_description_row($vbphrase['dbtech_vbsecurity_passwordreset_descr']);
	print_yes_no_row($vbphrase['dbtech_vbsecurity_are_you_sure_reset'], 'doresetpasswords', 0);	
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);	
	print_submit_row($vbphrase['dbtech_vbsecurity_reset_all_passwords'], false);
	
	print_form_header('vbsecurity', 'maintenance');
	construct_hidden_code('action', 'dosoftreset');
	print_table_header($vbphrase['dbtech_vbsecurity_passwordsoftreset'], 2, 0);
	print_description_row($vbphrase['dbtech_vbsecurity_passwordsoftreset_descr']);
	print_yes_no_row($vbphrase['dbtech_vbsecurity_are_you_sure_soft_reset'], 'dosoftresetpasswords', 0);	
	print_submit_row($vbphrase['dbtech_vbsecurity_reset_all_passwords'], false);
}

// #############################################################################
if ($_REQUEST['action'] == 'doreset')
{
	require_once(DIR . '/dbtech/vbsecurity/includes/adminfunctions.php');
	
	print_cp_header($vbphrase['passwordreset']);
	
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage' 			=> TYPE_UINT,
		'pagenumber' 		=> TYPE_UINT,
		'doresetpasswords' 	=> TYPE_BOOL
	));
	
	if (!$vbulletin->GPC['doresetpasswords'])
	{
		// Nothing to do
		print_stop_message('nothing_to_do');
	}
	
	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 1000;
	}

	$counter = VBSECURITY::$db->fetchOne('SELECT COUNT(*) FROM $user WHERE userid != ?', array($vbulletin->userinfo['userid']));
	if (!$counter)
	{
		$totalpages = 1;
	}
	else
	{
		$totalpages = ceil($counter / $vbulletin->GPC['perpage']);
	}
	
	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	echo '<p>' . $vbphrase['dbtech_vbsecurity_resetting_passwords'] . '</p>';
	
	$users = VBSECURITY::$db->fetchAll('
		SELECT userid, username, salt, email, languageid
		FROM $user
		WHERE userid != ?
		LIMIT :limitStart, :limitEnd
	', array(
		$vbulletin->userinfo['userid'],
		':limitStart' 		=> $startat,
		':limitEnd' 		=> $vbulletin->GPC['perpage']
	));
	
	foreach ($users as $userinfo)
	{
		echo construct_phrase($vbphrase['processing_x'], $userinfo['userid']) . "<br />\n";
		vbflush();

		// Attempt to insert what we found
		VBSECURITY::$db->delete('useractivation', array($userinfo['userid']), 'WHERE userid = ? AND type = 1');

		// Grab the new PW
		$newpassword = generatePassword(15);
		
		// Update it
		VBSECURITY::$db->query('UPDATE $user SET password = ?, passworddate = NOW() WHERE userid = ?', array(md5(md5($newpassword) . $userinfo['salt']), $userinfo['userid']), 'query_write');
		
		// Tell the user about it
		eval(fetch_email_phrases('dbtech_vbsecurity_resetpw', $userinfo['languageid']));
		vbmail($userinfo['email'], $subject, $message, false);		
	}
	
	if ($vbulletin->GPC['pagenumber'] < $totalpages)
	{
		$nxt = $vbulletin->GPC['pagenumber'] + 1;
		print_cp_redirect("vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=maintenance&action=doreset&page=$nxt&doresetpasswords=1&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=maintenance&amp;action=doreset&amp;page=$nxt&amp;doresetpasswords=1&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		define('CP_REDIRECT', 'vbsecurity.php?do=maintenance');
		print_stop_message('dbtech_vbsecurity_passwordreset_succeeded');
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'dosoftreset')
{
	print_cp_header($vbphrase['passwordreset']);
	
	$vbulletin->input->clean_array_gpc('r', array(
		'dosoftresetpasswords' 	=> TYPE_BOOL
	));
	
	if (!$vbulletin->GPC['dosoftresetpasswords'])
	{
		// Nothing to do
		print_stop_message('nothing_to_do');
	}
	
	// Mass update users
	VBSECURITY::$db->update('user', array('dbtech_vbsecurity_forcenewpass' => '1'), 'WHERE 1=1');
	
	define('CP_REDIRECT', 'vbsecurity.php?do=maintenance');
	print_stop_message('dbtech_vbsecurity_passwordsoftreset_succeeded');
}

print_cp_footer();